 var mo = require("./solver");
 /*
     .addVariabelSet("Nationality", ["Norwegian", "German", "Dane", "Swede", "Englishman"])
     .addVariabelSet("Color", ["Yellow", "Red", "White", "Blue", "Green"])
     .addVariabelSet("Smokes", ["Prince", "Blend", "Dunhill", "BlueMasters", "PallMall"])
     .addVariabelSet("Drinks", ["Bier", "Water", "Coffee", "Milk", "Tea"])
     .addVariabelSet("Animals", ["Birds", "Dogs", "Cats", "Horses", "Fish","Snake"])
     */
 var t = new mo()
     .addVariabelSet("Nationality", ["Norwegian", "Dane", "Englishman", "German", "Swede"])
     .addVariabelSet("Color", ["Yellow", "Blue", "Red", "Green", "White"])
     .addVariabelSet("Smokes", ["Dunhill", "Blend", "PallMall", "Prince", "BlueMasters"])
     .addVariabelSet("Drinks", ["Water", "Tea", "Milk", "Coffee", "Bier", ])
     .addVariabelSet("Animals", ["Cats", "Horses", "Birds", "Fish", "Dogs"])
     .addFunction("Neighbor", function(arg) {
         var prop1 = Object.keys(arg)[0];
         var prop2 = Object.keys(arg[Object.keys(arg)[1]])[0]
         var val1 = arg[prop1];
         var val2 = arg["Neighbor"][prop2];
         var propid1 = Object.keys(this.variabler).indexOf(prop1)
         var propid2 = Object.keys(this.variabler).indexOf(prop2)
         var valid1 = (this.variabler[prop1]).indexOf(val1)
         var valid2 = (this.variabler[prop2]).indexOf(val2)
         return ["checkBoth", propid1, propid2, valid1, valid2, [prop1, val1, "Besides", prop2, val2].join(" ")]
     })
     .addFunction("Neighbor_Before", function(arg) {
         var prop1 = Object.keys(arg)[0];
         var prop2 = Object.keys(arg[Object.keys(arg)[1]])[0]
         var val1 = arg[prop1];
         var val2 = arg["Neighbor_Before"][prop2];
         var propid1 = Object.keys(this.variabler).indexOf(prop1)
         var propid2 = Object.keys(this.variabler).indexOf(prop2)
         var valid1 = (this.variabler[prop1]).indexOf(val1)
         var valid2 = (this.variabler[prop2]).indexOf(val2)
         return ["checkLeft", propid1, propid2, valid1, valid2, [prop1, val1, "Before", prop2, val2].join(" ")]
     })
     .addFunction("Neighbor_After", function() {
         var prop1 = Object.keys(arg)[0];
         var prop2 = Object.keys(arg[Object.keys(arg)[1]])[0]
         var val1 = arg[prop1];
         var val2 = arg["Neighbor_After"][prop2];
         var propid1 = Object.keys(this.variabler).indexOf(prop1)
         var propid2 = Object.keys(this.variabler).indexOf(prop2)
         var valid1 = (this.variabler[prop1]).indexOf(val1)
         var valid2 = (this.variabler[prop2]).indexOf(val2)
         return ["checkRight", propid1, propid2, valid1, valid2, [prop1, val1, "After", prop2, val2].join(" ")]
     })
     .addFunction("House", function(arg) {
         var prop1 = Object.keys(arg)[0];
         var prop2 = prop1
         var propid1 = Object.keys(this.variabler).indexOf(prop1)
         var val1 = arg[prop1];
         var val2 = arg["House"];
         var valid1 = (this.variabler[prop1]).indexOf(val1)
         return ['checkPos', propid1, propid1, valid1, val2, [prop1, val1, "House", val2].join(" ")]
     })
     .addClause({
         "Nationality": "Norwegian",
         "House": 0
     })
     .addClause({
         "Drinks": "Milk",
         "House": 2
     })
     .addClause({
         "Nationality": "Norwegian",
         "Neighbor": {
             "Color": "Blue"
         }
     })
     .addClause({
         "Nationality": "Englishman",
         "Color": "Red"
     })
     .addClause({
         "Smokes": "Blend",
         "Neighbor": {
             "Drinks": "Water"
         }
     })
     .addClause({
         "Nationality": "Swede",
         "Animals": "Dogs"
     })
     .addClause({
         "Nationality": "Dane",
         "Drinks": "Tea"
     })
     .addClause({
         "Color": "Green",
         "Drinks": "Coffee"
     })
     .addClause({
         "Smokes": "PallMall",
         "Animals": "Birds"
     })
     .addClause({
         "Color": "Yellow",
         "Smokes": "Dunhill"
     })
     .addClause({
         "Nationality": "German",
         "Smokes": "Prince"
     })
     .addClause({
         "Smokes": "Blend",
         "Neighbor": {
             "Animals": "Cats"
         }
     })
     .addClause({
         "Animals": "Horses",
         "Neighbor": {
             "Smokes": "Dunhill"
         }
     })
     .addClause({
         "Smokes": "BlueMasters",
         "Drinks": "Bier"
     })
     .addClause({
         "Color": "Green",
         "Neighbor_Before": {
             "Color": "White"
         }
     })
     .on("status", function(per, total, ic, ioa, iomax) {
         console.log("Status", per, ic + " of " + total, "sat " + ioa + " of " + iomax);
     })
     .on("part", function(iterations, foundl, foundt, total, sos, rules) {
         this.parts = this.parts || [];
         this.parts.push([iterations, foundt, total, sos, rules]);
     })
     .on("done", function(result) {
         if (result) {
             console.log("FOUND SOLUTION:", result);
             this.printit(result);
             if (this.parts && this.parts.length) {
                 var rr = this.parts.pop();
                 console.log(rr[4]);
             }
         } else {
             console.log("NO SOLUTION");
             console.log("Closest:");
             if (this.parts && this.parts.length) {
                 var rr = this.parts.pop();
                 // console.log("RRRRR",rr);
                 this.printit(rr[3])
                 console.log(rr[4]);
             }
         }
     })
     .solve()